/*
** File:    UFJob.h
** Author:  Rick Cameron
** Date:    13 Mar 93
**
** Purpose: Declarations of types and functions to support job management.
*/

#if !defined (UFJOB_H)

#define UFJOB_H
// make sure the structures are byte-aligned
#if !defined(PLAT_UNIX) && !defined (MAINWIN)
#if defined(_MSC_VER)
  #pragma pack(1)
#elif defined(__BORLANDC__)
  #pragma option -a1
#endif
#endif

#ifdef __cplusplus
extern "C"
{
#endif

struct JobInfo
{
    UFTInt32u jobId;
    struct JobInfo FAR *prev;
    struct JobInfo FAR *next;

    // use this pointer to point to your data block
    void FAR *data;
};

extern void InitForJob (UFTInt32u jobId);
extern void TermForJob (UFTInt32u jobId);

extern struct JobInfo FAR *FindJobInfo (UFTInt32u jobId);

// you must implement these
extern void InitJob (struct JobInfo FAR *jobInfo);
extern void TermJob (struct JobInfo FAR *jobInfo);

#ifdef __cplusplus
}
#endif
#endif // !defined (UFJOB_H)
