
//<HEADER_BEGIN>
//================================================
//File name: Uxdmapi.h
//Date : January, 15 2002  12:15
//Copyright (c) 2002 - Crystal Decisions Corp.
//================================================
//<HEADER_END>

#if !defined (UXDMAPI_H)
#define UXDMAPI_H

// Set 1-byte structure alignment
#if defined (__BORLANDC__)      // Borland C/C++
  #pragma option -a-
#elif defined (_MSC_VER)        // Microsoft Visual C++
  #if _MSC_VER >= 900           // MSVC 2.x and later
    #pragma pack (push)
  #endif
  #pragma pack (1)
#endif

#if defined (__cplusplus)
extern "C"
{
#endif

#include "crsMAPI.h"

#define UXDMAPIType             0

typedef struct UXDMAPIOptionsA
{
    WORD structSize;

    char FAR *toList;           // 'toList' and 'ccList' are ignored
    char FAR *ccList;           // if specifying recipients below.

    char FAR *subject;
    char FAR *message;

    WORD nRecipients;           // 'nRecipients' must be 0 if specifying
    lpMapiRecipDescA recipients; // To and CC lists above.

    char FAR *userName;
    char FAR *password;

    WORD nEncodedBytes;

#if defined (__cplusplus)
public:
    UXDMAPIOptionsA()
    {
        toList  = NULL;
        ccList  = NULL;
        subject = NULL;
        message = NULL;
        recipients = NULL;
        userName = NULL;
        password = NULL;
        nEncodedBytes = 0;
    };
#endif

}
    UXDMAPIOptionsA;

typedef struct UXDMAPIOptionsW
{
    WORD structSize;

    wchar_t FAR *toList;           // 'toList' and 'ccList' are ignored
    wchar_t FAR *ccList;           // if specifying recipients below.

    wchar_t FAR *subject;
    wchar_t FAR *message;

    WORD nRecipients;            // 'nRecipients' must be 0 if specifying
    lpMapiRecipDescW recipients; // To and CC lists above.

    wchar_t FAR *userName;
    wchar_t FAR *password;

    WORD nEncodedBytes;


#if defined (__cplusplus)
public:
    UXDMAPIOptionsW()
    {
        toList  = NULL;
        ccList  = NULL;
        subject = NULL;
        message = NULL;
        recipients = NULL;
        userName = NULL;
        password = NULL;
        nEncodedBytes = 0;
    };
#endif

}
    UXDMAPIOptionsW;

#ifdef UNICODE
typedef UXDMAPIOptionsW UXDMAPIOptions;
#else
typedef UXDMAPIOptionsA UXDMAPIOptions;
#endif  //UNICODE 


#define UXDMAPIOptionsSize      (sizeof (UXDMAPIOptions))


#if defined (__cplusplus)
}
#endif

// Reset structure alignment
#if defined (__BORLANDC__)
  #pragma option -a.
#elif defined (_MSC_VER)
  #if _MSC_VER >= 900
    #pragma pack (pop)
  #else
    #pragma pack ()
  #endif
#endif

#endif // UXDMAPI_H
