
//<HEADER_BEGIN>
//================================================
//File name: uxfodbc.h
//Date : January, 15 2002  12:15
//Copyright (c) 2002 - Crystal Decisions Corp.
//================================================
//<HEADER_END>

#if !defined (UXFODBC_H)
#define UXFODBC_H

// Set 1-byte structure alignment
#if defined (__BORLANDC__) // Borland C/C++
  #pragma option -a-
#elif defined (_MSC_VER) // Microsoft Visual C++
  #if _MSC_VER >= 900 // MSVC 2.x and later
    #pragma pack (push)
  #endif
  #pragma pack (1)
#endif

#if defined (__cplusplus)
extern "C"
{
#endif

#define MAX_ODBC_SOURCES        100         // Max. # of ODBC data sources
#define UXFODBCType            MAX_ODBC_SOURCES + 1

typedef struct UXFODBCOptionsA
{
    WORD structSize;

    char FAR *dataSourceName;
    char FAR *dataSourceUserID;
    char FAR *dataSourcePassword;
    char FAR *exportTableName;

	WORD nEncodedBytes;

#if defined (__cplusplus)
public :
    UXFODBCOptionsA()
    {
        structSize = sizeof(UXFODBCOptionsA);
        dataSourceName = NULL;
        dataSourceUserID = NULL;
        dataSourcePassword = NULL;
        exportTableName = NULL;

		nEncodedBytes = 0;
    };
#endif
}
    UXFODBCOptionsA;

typedef struct UXFODBCOptionsW
{
    WORD structSize;

    wchar_t FAR *dataSourceName;
    wchar_t FAR *dataSourceUserID;
    wchar_t FAR *dataSourcePassword;
    wchar_t FAR *exportTableName;

	WORD nEncodedBytes;

#if defined (__cplusplus)
public :
    UXFODBCOptionsW()
    {
        structSize = sizeof(UXFODBCOptionsW);
        dataSourceName = NULL;
        dataSourceUserID = NULL;
        dataSourcePassword = NULL;
        exportTableName = NULL;

		nEncodedBytes = 0;
    };
#endif
}
    UXFODBCOptionsW;


#define UXFODBCOptionsASize (sizeof (UXFODBCOptionsA))
#define UXFODBCOptionsWSize (sizeof (UXFODBCOptionsW))


#ifdef UNICODE
typedef UXFODBCOptionsW UXFODBCOptions;
#define UXFODBCOptionsSize UXFODBCOptionsWSize 
#else
typedef UXFODBCOptionsA UXFODBCOptions;
#define UXFODBCOptionsSize UXFODBCOptionsASize
#endif  //UNICODE 


#if defined (__cplusplus)
}
#endif

// Reset structure alignment
#if defined (__BORLANDC__)
  #pragma option -a.
#elif defined (_MSC_VER)
  #if _MSC_VER >= 900
    #pragma pack (pop)
  #else
    #pragma pack ()
  #endif
#endif

#endif 
