/*
** File:    UFDll.h
** Author:  Rex Benning, Rick Cameron
** Date:    3 Mar 93
**
** Purpose: Declarations for a user-defined function DLL
**
** Modified : Ivanka Jankovic
** Date: 14.12.1995
** Added time and date-time types
*/

#if !defined (UFDLL_H)
#define UFDLL_H

#if !defined (CRDLL_H)
  #include "crdll.h"
#endif

// Set 1-byte structure alignment
#if !defined (PLAT_UNIX) && !defined (MAINWIN)
  #if defined (__BORLANDC__) // Borland C/C++
    #pragma option -a-
  #elif defined (_MSC_VER) // Microsoft Visual C++
    #if _MSC_VER >= 900 // MSVC 2.x and later
      #pragma pack (push)
    #endif
    #pragma pack (1)
  #endif
#endif

#if !defined(_WIN32)
  #define PASCAL
#endif

#if defined (__cplusplus)
extern "C"
{
#endif

#define UFVersion1              0x0100
#define UFVersion5              0x0500

#define UFMaxNArguments 50

#define UFMaxStringLength 254
#define UFUnknownStringLength MaxInt16u

typedef CRInt8s UFTInt8s;
typedef CRInt8u UFTInt8u;

typedef CRInt16s UFTInt16s;
typedef CRInt16u UFTInt16u;

typedef CRInt32s UFTInt32s;
typedef CRInt32u UFTInt32u;

typedef CRNumber  UFTNumber;
typedef UFTNumber UFTCurrency;

typedef CRDate UFTDate;
typedef CRTime UFTTime;
typedef CRDateTime UFTDateTime;

typedef CRBoolean UFTBoolean;

#define UFNumberScalingFactor CRNumberScalingFactor

typedef CRInt8u UFTRangeInfo;
#define UFRngInfoExcludeUpperBound 0x01
#define UFRngInfoExcludeLowerBound 0x02
#define UFRngInfoNoUpperBound      0x04
#define UFRngInfoNoLowerBound      0x08

typedef enum UFError
{
    UFUserError = -1,
    UFNoError,
    UFNoMemory,
    UFStringTooBig,
    UFDivideByZero,
    UFArrayIndexTooBig,
    UFStringIndexTooBig,
    UFNotEnoughParameters,
    UFMemCalcFail
}
    UFError;

typedef enum UFReturnTypes
{
    UFUndefinedReturn,
    UFStringReturn,
    UFNumberReturn,
    UFDateReturn,
    UFBooleanReturn,
    UFCurrencyReturn,
    UFDateRangeReturn,
    UFNumberRangeReturn,
    UFCurrencyRangeReturn,
    UFStringRangeReturn,
    UFStringArrayReturn,
    UFNumberArrayReturn,
    UFDateArrayReturn,
    UFBooleanArrayReturn,
    UFCurrencyArrayReturn,
    UFTimeReturn,
    UFDateTimeReturn,
    UFTimeRangeReturn,
    UFDateTimeRangeReturn,
    UFTimeArrayReturn,
    UFDateTimeArrayReturn,
    UFNumberRangeArrayReturn,
    UFCurrencyRangeArrayReturn,
    UFDateRangeArrayReturn,
    UFTimeRangeArrayReturn,
    UFDateTimeRangeArrayReturn,
    UFStringRangeArrayReturn,
    UFLastReturnType
}
    UFReturnTypes;

typedef enum UFTypeDefs
{
    UFUndefinedType,
    UFNumber,
    UFCurrency,
    UFNumberToCurrency,
    UFUnusedType0, // Ignore
    UFBoolean,
    UFDate,
    UFStringArg,
    UFNumberRange,
    UFCurrencyRange,
    UFNumberToCurrencyRange,
    UFUnusedType1, // Ignore
    UFUnusedType2, // Ignore
    UFDateRange,
    UFStringRange,
    UFNumberArray,
    UFCurrencyArray,
    UFNumberToCurrencyArray,
    UFUnusedType3, // Ignore
    UFBooleanArray,
    UFDateArray,
    UFStringArray,
    UFUnusedType4, // Ignore
    UFTime,
    UFDateTime,
    UFTimeRange,
    UFDateTimeRange,
    UFTimeArray,
    UFDateTimeArray,
    UFNumberRangeArray,
    UFCurrencyRangeArray,
    UFNumberToCurrencyRangeArray,
    UFDateRangeArray,
    UFTimeRangeArray,
    UFDateTimeRangeArray,
    UFStringRangeArray
}
    UFTypeDefs;

typedef union UFParamUnion
{
    UFTNumber   ParamNumber;
    UFTCurrency ParamCurrency;
    UFTBoolean  ParamBoolean;
    UFTDate     ParamDate;
    UFTTime     ParamTime;
    UFTDateTime ParamDateTime;
    char FAR *  ParamString;

    struct ParamNumberRange
    {
        UFTNumber ParamNumberStart;
        UFTNumber ParamNumberEnd;
    }
        ParamNumberRange;

    struct ParamCurrencyRange
    {
        UFTCurrency ParamCurrencyStart;
        UFTCurrency ParamCurrencyEnd;
    }
        ParamCurrencyRange;

    struct ParamDateRange
    {
        UFTDate ParamDateStart;
        UFTDate ParamDateEnd;
    }
        ParamDateRange;

    struct ParamTimeRange
    {
        UFTTime ParamTimeStart;
        UFTTime ParamTimeEnd;
    }
        ParamTimeRange;

    struct ParamDateTimeRange
    {
        UFTDateTime ParamDateTimeStart;
        UFTDateTime ParamDateTimeEnd;
    }
        ParamDateTimeRange;

    struct ParamStringRange
    {
        char FAR *ParamStringStart;
        char FAR *ParamStringEnd;
    }
        ParamStringRange;

    UFTNumber   FAR *ParamNumberArray;
    UFTCurrency FAR *ParamCurrencyArray;
    UFTBoolean  FAR *ParamBooleanArray;
    UFTDate     FAR *ParamDateArray;
    UFTTime     FAR *ParamTimeArray;
    UFTDateTime FAR *ParamDateTimeArray;
    char FAR *  FAR *ParamStringArray;

    // Range arrays are implemented as pairs of entries: even for starts, odd for ends.
    UFTNumber   FAR *ParamNumberRangeArray;
    UFTCurrency FAR *ParamCurrencyRangeArray;
    UFTDate     FAR *ParamDateRangeArray;
    UFTTime     FAR *ParamTimeRangeArray;
    UFTDateTime FAR *ParamDateTimeRangeArray;
    char FAR *  FAR *ParamStringRangeArray;

    void        FAR *ParamArrayPointer;

    struct UFMemCalcParam FAR *MemCalcSubParam;
}
    UFParamUnion;

typedef struct UFParamListElement
{
    UFTInt16u StructSize;
    struct UFParamListElement FAR *NextParam;
    // For range arrays, this is the number of pairs of values (start and end).
    UFTInt16s ParamLength;
    UFTypeDefs ParamType;
    UFParamUnion Parameter;
    
    // One entry for ranges, N entries for range arrays.
    UFTRangeInfo FAR *ParamRangeInfo;
}
    UFParamListElement;
#define UFParamListElementSize  (sizeof (UFParamListElement))

typedef struct UFParamListElement0 // Obsolete: use the preceding structure instead.
{
    UFTInt16u StructSize;
    struct UFParamListElement FAR *NextParam;
    UFTInt16s ParamLength;
    UFTypeDefs ParamType;
    UFParamUnion Parameter;
}
    UFParamListElement0;
#define UFParamListElement0Size  (sizeof (UFParamListElement0))

typedef enum UFMemCalcParmTypes
{
    UFLiteral,
    UFArray,
    UFUnusedType, // Ignore
    UFExpression
}
    UFMemCalcParmTypes;

// For use when asking the DLL how much memory to allocate for a returned string or array.
typedef struct UFMemCalcParam 
{
    UFTInt16u StructSize;
    struct UFMemCalcParam FAR *NextMemCalcParam;
    
    // For strings, the length includes the trailing null byte. For arrays (future), it is
    // the number of entries. For range arrays (future), this is the number of pairs of
    // values (start and end).
    UFTInt16s MemCalcParamLength; 
    
    UFMemCalcParmTypes MemCalcLiteralFlag;
    UFTypeDefs MemCalcParamType;
    UFParamUnion MemCalcParameter;

    // One entry for ranges, N entries for range arrays (future).
    UFTRangeInfo FAR *MemCalcRangeInfo;
}
    UFMemCalcParam;
#define UFMemCalcParamSize      (sizeof (UFMemCalcParam))

typedef struct UFMemCalcParam0 // Obsolete: use the preceding structure instead.
{
    UFTInt16u StructSize;
    struct UFMemCalcParam FAR *NextMemCalcParam;
    UFTInt16s MemCalcParamLength; 
    UFMemCalcParmTypes MemCalcLiteralFlag;
    UFTypeDefs MemCalcParamType;
    UFParamUnion MemCalcParameter;
}
    UFMemCalcParam0;
#define UFMemCalcParam0Size       (sizeof (UFMemCalcParam0))

typedef union UFReturnUnion
{
    UFTNumber   ReturnNumber;
    UFTCurrency ReturnCurrency;
    UFTBoolean  ReturnBoolean;
    UFTDate     ReturnDate;
    UFTTime     ReturnTime;
    UFTDateTime ReturnDateTime;
    char FAR *  ReturnString;

    struct ReturnNumberRange
    {
        UFTNumber ReturnNumberStart;
        UFTNumber ReturnNumberEnd;
    }
        ReturnNumberRange;

    struct ReturnCurrencyRange
    {
        UFTCurrency ReturnCurrencyStart;
        UFTCurrency ReturnCurrencyEnd;
    }
        ReturnCurrencyRange;

    struct ReturnDateRange
    {
        UFTDate ReturnDateStart;
        UFTDate ReturnDateEnd;
    }
        ReturnDateRange;

    struct ReturnTimeRange
    {
        UFTTime ReturnTimeStart;
        UFTTime ReturnTimeEnd;
    }
        ReturnTimeRange;

    struct ReturnDateTimeRange
    {
        UFTDateTime ReturnDateTimeStart;
        UFTDateTime ReturnDateTimeEnd;
    }
        ReturnDateTimeRange;

    struct ReturnStringRange
    {
        char FAR *ReturnStringStart;
        char FAR *ReturnStringEnd;
    }
        ReturnStringRange;

    UFTNumber   FAR *ReturnNumberArray;
    UFTCurrency FAR *ReturnCurrencyArray;
    UFTBoolean  FAR *ReturnBooleanArray;
    UFTDate     FAR *ReturnDateArray;
    UFTTime     FAR *ReturnTimeArray;
    UFTDateTime FAR *ReturnDateTimeArray;
    char FAR *  FAR *ReturnStringArray;

    // Range arrays are implemented as pairs of entries: even for starts, odd for ends.
    UFTNumber   FAR *ReturnNumberRangeArray;
    UFTCurrency FAR *ReturnCurrencyRangeArray;
    UFTDate     FAR *ReturnDateRangeArray;
    UFTTime     FAR *ReturnTimeRangeArray;
    UFTDateTime FAR *ReturnDateTimeRangeArray;
    char FAR *  FAR *ReturnStringRangeArray;

    UFTInt32s UFReturnUserError;
}
    UFReturnUnion;

typedef enum UFMemCalcType
{
    UFCalcStringLength,
    UFCalcArraySize
}
    UFMemCalcType;

typedef struct UFParamBlock
{
    UFTInt16u StructSize;

    UFReturnUnion ReturnValue;
    // For range arrays, this is the number of pairs of values (start and end).
    UFTInt16s ReturnValueLength;
    
    UFTInt16s FunctionNumber;
    void (FAR PASCAL *UFErrorHandler) (UFError);
    UFParamListElement FAR *UFParamList;
    UFTInt32u JobId;

    // One entry for ranges, N entries for range arrays.
    UFTRangeInfo FAR *ReturnRangeInfo;
}
    UFParamBlock;
#define UFParamBlockSize        (sizeof (UFParamBlock))

typedef struct UFParamBlock0 // Obsolete: use the preceding structure instead.
{
    UFTInt16u StructSize;
    UFReturnUnion ReturnValue;
    UFTInt16s ReturnValueLength;
    UFTInt16s FunctionNumber;
    void (FAR PASCAL *UFErrorHandler) (UFError);
    UFParamListElement FAR *UFParamList;
    UFTInt32u JobId;
}
    UFParamBlock0;
#define UFParamBlock0Size       (sizeof (UFParamBlock0))

// For use when asking the DLL how much memory to allocate for a returned string or array.
typedef struct UFMemCalcBlock
{
    UFTInt16u StructSize;
    UFMemCalcType MemCalcCommand;
    // For range arrays, this is the number of pairs of values (start and end).
    UFTInt16s UFMemCalcArrayLength;
    UFTInt16s UFMemCalcStringLength;
    UFMemCalcParam FAR *UFMemCalcParamList; // For calculating string sizes
    UFParamListElement FAR *UFParamList;    // For calculating array sizes.
}
    UFMemCalcBlock;
#define UFMemCalcBlockSize      (sizeof (UFMemCalcBlock))

typedef struct UFFunctionDefStrings
{
    char FAR *FuncDefString;
    UFError (FAR PASCAL *UFEntry) (UFParamBlock FAR *);
    UFError (FAR PASCAL *UFMemCalcFunc) (UFMemCalcBlock FAR *);
}
    UFFunctionDefStrings;

typedef struct UF5FunctionDefStrings
{
    char FAR *FuncDefString;
    UFError (FAR PASCAL *UFEntry) (UFParamBlock FAR *);
    UFError (FAR PASCAL *UFMemCalcFunc) (UFMemCalcBlock FAR *);
    UFTBoolean callOnlyWhilePrintingRecords;
    UFTBoolean hasSideEffects;
}
    UF5FunctionDefStrings;

/* An encasing structure for extendability, the first element will indicate, and check, 
** which version of the interface is in use. It is set by the compiler using the 
** sizeof operator. Any changes to the interface must change the size of this structure.
** typedef struct
*/
typedef struct UFFunctionDefStringList
{
    UFTInt16u StructSize;
    UFFunctionDefStrings FAR *UFFunctionDefStrPtr;
}
    UFFunctionDefStringList;
#define UFFunctionDefStringListSize (sizeof (UFFunctionDefStringList))

typedef struct UF5FunctionDefStringList
{
    UFTInt16u StructSize;
    UF5FunctionDefStrings FAR *UF5FunctionDefStrPtr;
}
    UF5FunctionDefStringList;
#define UF5FunctionDefStringListSize (sizeof (UF5FunctionDefStringList))

typedef struct UFFunctionTemplates
{
    char FAR *FuncTemplate;
}
    UFFunctionTemplates;

/* An encasing structure for extendability, the first element will indicate, and check,
** which version of the interface is in use. It is set by the compiler using the sizeof 
** operator. Any changes to the interface must change the size of this structure.
** typedef struct
*/
typedef struct UFFunctionTemplateList
{
    UFTInt16u StructSize;
    UFFunctionTemplates FAR *UFFuncTemplatePtr;
}
    UFFunctionTemplateList;
#define UFFunctionTemplateListSize (sizeof (UFFunctionTemplateList))

typedef struct UFFunctionExamples
{
    char FAR *FuncExample;
}
    UFFunctionExamples;

/* An encasing structure for extendability, the first element will indicate, and check,
** which version of the interface is in use. It is set by the compiler using the sizeof
** operator. Any changes to the interface must change the size of this structure.
** typedef struct
*/
typedef struct UFFunctionExampleList
{
    UFTInt16u StructSize;
    UFFunctionExamples FAR *FuncExample;
}
    UFFunctionExampleList;
#define UFFunctionExampleListSize (sizeof (UFFunctionExampleList))

#if defined (__cplusplus)
}
#endif

// Reset structure alignment
#if !defined (PLAT_UNIX) && !defined (MAINWIN)
  #if defined (__BORLANDC__)
    #pragma option -a.
  #elif defined (_MSC_VER)
    #if _MSC_VER >= 900
      #pragma pack (pop)
    #else
      #pragma pack ()
    #endif
  #endif
#endif

#endif // UFDLL_H
