unit SetLoc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, CRDelphi, ExtCtrls;

type
  TFrmSetLoc = class(TForm)
    pnlTables: TPanel;
    lblTableNumber: TLabel;
    lbTableNumbers: TListBox;
    pnlTables2: TPanel;
    lblTableName: TLabel;
    lblTablePath: TLabel;
    lblTableType: TLabel;
    lblTableDLLName: TLabel;
    lblTableDescriptiveName: TLabel;
    editTableName: TEdit;
    btnSetName: TButton;
    editTablePath: TEdit;
    btnSetPath: TButton;
    editTablePassword: TEdit;
    editTableTableType: TEdit;
    editTableDLLName: TEdit;
    editTableDescriptiveName: TEdit;
    SetLocation: TButton;
    BitBtn1: TBitBtn;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    EditTableUserID: TEdit;
    Label2: TLabel;
    EditDBPassword: TEdit;
    lkj: TLabel;
    procedure btnSetNameClick(Sender: TObject);
    procedure btnSetPathClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure lbTableNumbersClick(Sender: TObject);
    procedure SetLocationClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmSetLoc: TFrmSetLoc;

implementation

uses UnitPath, Main;

{$R *.DFM}

procedure TFrmSetLoc.btnSetNameClick(Sender: TObject);
begin
  {Set the dialog default filename, filter and title}
  OpenDialog1.FileName := '*' + ExtractFileExt(editTableName.Text);
  OpenDialog1.Filter := 'Database Files (*' + UpperCase(OpenDialog1.FileName)
     + ')|*' + OpenDialog1.FileName + '|' + 'All files (*.*)|*.*';
  OpenDialog1.Title := 'Choose New Table...';
  OpenDialog1.InitialDir := editTablePath.Text;
  if OpenDialog1.Execute then
  begin
    Refresh;
    editTableName.Text := ExtractFileName(OpenDialog1.FileName);
    editTablePath.Text := ExtractFilePath(OpenDialog1.FileName);
  end;
end;

procedure TFrmSetLoc.btnSetPathClick(Sender: TObject);
begin
  dlgTablePath := TdlgTablePath.Create(Application);
  dlgTablePath.ShowModal;
  dlgTablePath.Release;
end;

procedure TFrmSetLoc.FormShow(Sender: TObject);
var
   i, NumTables : integer; {used for looping}
begin
{check for a valid job number first}
LBTableNumbers.Items.Clear;
if Main.JobNumber > 0 Then
begin
   {Get Number of Tables}
   NumTables := PEGetNTables (Main.JobNumber);

   {Fill List Box with Table Count}
   for i := 1 to NumTables do
     LBTableNumbers.Items.Add (IntToStr (i));

   LBTableNumbers.itemindex := 0;
   lbTableNumbersClick(Sender);
end;
end;

procedure TFrmSetLoc.lbTableNumbersClick(Sender: TObject);

var
  TableLocation : PETableLocation; {table location structure}
  TableType : PETableType;  {Table info structure}
  SessionInfo : PESessionInfo;

begin
   {Retrieve table name and directory path}
   TableLocation.StructSize := SizeOf (PETableLocation);
   PEGetNthTableLocation (Main.JobNumber,LBTableNumbers.ItemIndex, TableLocation);
   EditTableName.Text := ExtractFileName (StrPas (TableLocation.Location));
   EditTablePath.Text := ExtractFilePath (StrPas (TableLocation.Location));

   {Retreive table information}
   TableType.StructSize := SizeOf (PeTableType);
   PEGetNthTableType (Main.JobNumber, LBTableNumbers.ItemIndex,TableType);
   EditTableDllName.Text := TableType.DLLName;
   EditTableDescriptiveName.Text := StrPas (TableType.DescriptiveName);
   case TableType.DBType of
   1 : EditTableTableType.Text := 'Standard';
   2 : EditTableTableType.Text := 'SQL';
   3 : EditTableTableType.Text := 'Unknown'; {this should never be used}
   end;

   {If table is access or paradox enable the userid and password boxes}
   if EditTableDllName.Text = 'pdbbde.dll' then
      {Check for paradox}
      begin
         {since password not saved in report change text and enable}
         {Paradox does not use a userID}
          editTablePassword.enabled := True;
          editTablePassword.Text := '';
      end
   else if EditTableDllName.Text = 'PDBDAO.DLL' then
      {Check for access tables, and retrieve userid}
      begin
          SessionInfo.StructSize := SizeOf (PeSessionInfo);
          PEGetNthTableSessionInfo (Main.JobNumber, LBTableNumbers.ItemIndex, SessionInfo);
          EditTablePassword.enabled := True;
          EditTablePassword.Text := '';
          EditDBPassword.Enabled := True;
          EditDBPassword.Text := '';
          EditTableUserID.Enabled := True;
          EditTableUserID.Text := SessionInfo.UserID;
      end;
end;

procedure TFrmSetLoc.SetLocationClick(Sender: TObject);
var
  TableLocation : PETableLocation; {table location structure}
  LogOnInfo : PELogOnInfo; {Paradox password set through logoninfo structure}
  SessionInfo : PESessionInfo; {The access session info for passwords}

begin
   {Retrieve table name and directory path}
   TableLocation.StructSize := SizeOf (PETableLocation);
   StrPCopy (TableLocation.Location, EditTablePath.Text + EditTableName.Text);
   PESetNthTableLocation (Main.JobNumber,LBTableNumbers.ItemIndex, TableLocation);

   {If Paradox or access tables check if a password has been entered}
   {If password entered send to the print job}
   if (EditTableDllName.Text = 'pdbbde.dll') and not (editTablePassword.Text = '') then
   begin
      {Paradox password set through log on info}
      LogOnInfo.StructSize := SizeOf (PELogOnInfo);
      {Get the logoninfo structure to fill the report}
      PEGetNthTableLogOnInfo (Main.JobNumber,LBTableNumbers.ItemIndex, LogOnInfo);

      {copy the password to logoninfostructure and pass to the report}
      StrPCopy (LogOnInfo.Password,editTablePassword.Text);
      PESetNthTableLogOnInfo (Main.JobNumber,LBTableNumbers.ItemIndex, LogOnInfo, False);
   end
   else if EditTableDllName.Text = 'PDBDAO.DLL' then
     if (not (EditTablePassword.Text = '')) or (not (EditDBPassword.Text = '')) then
      {Check to see if any of the passwords have been set}
      begin
         SessionInfo.StructSize := SizeOf (PeSessionInfo);

         {Fill Sessioninfo structure from report}
         PEGetNthTableSessionInfo (Main.JobNumber, LBTableNumbers.ItemIndex, SessionInfo);

         {Set the username and password.  The DBPassword is set by preceding with}
         {a carriage return}
         StrPCopy (SessionInfo.PassWord,EditTablePassword.Text+ Chr (10) + EditDBPassword.Text);
         StrPCopy (SessionInfo.UserID, EditTableUserID.Text);
         PESetNthTableSessionInfo (Main.JobNumber, LBTableNumbers.ItemIndex, SessionInfo,True);
      end;
end;

end.
