unit UnitPath;

interface

uses
  SysUtils, Classes, Forms, Controls, StdCtrls, Buttons,
  ExtCtrls, FileCtrl;

type
  TdlgTablePath = class(TForm)
    DriveComboBox1: TDriveComboBox;
    DirListBox1: TDirectoryListBox;
    EditDestPath: TEdit;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    procedure BtnOKClick(Sender: TObject);
    procedure DirListBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dlgTablePath: TdlgTablePath;

implementation

{$R *.DFM}

uses SetLoc, Main;

procedure TdlgTablePath.FormShow(Sender: TObject);

begin
  try
    if not DirectoryExists(FrmSetLoc.editTablePath.Text) then
       DirListBox1.Directory := FrmSetLoc.editTablePath.Text;
  except
    DirListBox1.Directory := ExtractFilePath (strpas (Main.FileNme));
  end;
  editDestPath.Text := DirListBox1.Directory;
end;

procedure TdlgTablePath.DirListBox1Change(Sender: TObject);
begin
  editDestPath.Text := DirListBox1.Directory;
end;

procedure TdlgTablePath.BtnOKClick(Sender: TObject);
begin
  frmSetLoc.editTablePath.Text := DirListBox1.Directory;
  frmSetLoc.editTablePath.SetFocus;
  frmSetLoc.editTablePath.SelectAll;
end;

end.
