//
// Defines the functions which the Hoard DLL will export
//

///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998-2000, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//
// Note: This file was created by Crystal Decisions in June 2002.
//
//////////////////////////////////////////////////////////////////////////////


#include <stdlib.h>
#include <string.h>
#ifndef WIN32
#include <strings.h>
#endif
#include "config.h"

#if USE_PRIVATE_HEAPS
#include "privateheap.h"
#define HEAPTYPE privateHeap
#else
#include "threadheap.h"
#define HEAPTYPE threadHeap
#endif

#include "hoarddll.h"
#include "processheap.h"
#include "block.h"
#include "wrapper.h"
#include "arch-specific.h"

static wrapper TheWrapper;
char * wrapper::buf;
processHeap * wrapper::TheRealAllocator;
hoardLockType wrapper::_lock;


// Replaces malloc()
void * WINAPI crHeapAlloc (size_t sz)
{
  processHeap * pHeap = TheWrapper.TheAllocator();
  void * addr = pHeap->getHeap(pHeap->getHeapIndex()).malloc (sz);
  return addr;
}


// Replaces free()
void WINAPI crHeapFree (void * ptr)
{
  if ( ptr == NULL )
    return;

  processHeap * pHeap = TheWrapper.TheAllocator();
#if USE_PRIVATE_HEAPS
  pHeap->getHeap(pHeap->getHeapIndex()).free(ptr);
#else
  pHeap->free (ptr);
#endif
}

// Replaces realloc()
void * WINAPI crHeapRealloc (void * ptr, size_t sz)
{
  if (ptr == NULL)
  {
    return crHeapAlloc (sz);
  }

  if (sz == 0)
  {
    crHeapFree (ptr);
    return NULL;
  }

  // Allocate a new block of size sz.

  void * buf = crHeapAlloc (sz);

  // Find out how large the original object was.

  size_t objSize = HEAPTYPE::objectSize (ptr);

  // Copy the contents of the original object
  // up to the size of the new block.

  size_t minSize = (objSize < sz) ? objSize : sz;
  memcpy (buf, ptr, minSize);

  // Free the old block.

  crHeapFree (ptr);

  // Return a pointer to the new one.

  return buf;
}


// Replaces _msize()  (Microsoft-specific function)
size_t WINAPI crHeapActualSize(void * ptr )
{
  if ( ptr == NULL )
    return 0;
  
#ifdef WIN32
  size_t sz = HEAPTYPE::getActualSize (ptr);
#else
  size_t sz = HEAPTYPE::objectSize (ptr);
#endif
  return sz;
}


// Replaces _expand()  (Microsoft-specific function)
void * WINAPI crHeapExpand( void *ptr, size_t sz )
{
  // What a terrible function!  Who would use _expand()?
  // Expanded as much as possible, for me, is going to be "not at all",
  // so I'll always return the original ptr.

  // The user has to call _msize() on the resulting pointer to find
  // out if the _expand() was successful.  They will experience
  // disappointment here, and call realloc() like they were supposed to
  // in the first place.

  // Who thinks up these things, anyway?
  return ptr;
}

#ifdef WIN32
int WINAPI crIsHeapPtr( void* ptr )
{
  // Checks to see if pointer has been allocated by Hoard or not.
  // Only works on win32, where we keep track of individual allocation segments.
  if ( ptr == NULL )
    return false;
  else
    return hoardIsHoardPtr(ptr) ? 1 : 0;
}
#endif // WIN32

