///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998-2000, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//
// Note: This file was created by Crystal Decisions in June 2002.
//
//////////////////////////////////////////////////////////////////////////////

//
// Defines the functions which the Hoard DLL will export
//

#if !defined (HOARDDLL_H)
#define HOARDDLL_H


extern "C"
{
  void * WINAPI crHeapAlloc (size_t sz);
  void   WINAPI crHeapFree (void * ptr);
  void * WINAPI crHeapRealloc (void * ptr, size_t sz);
  size_t WINAPI crHeapActualSize(void * ptr);
  void * WINAPI crHeapExpand( void *ptr, size_t sz);
  int    WINAPI crIsHeapPtr( void* ptr );
}

#endif  // HOARDDLL_H

