#include <iostream.h>
#include <math.h>

#include "config.h"
#include "heap.h"

// Use this procedure to rebuild the _sizeTable initialization
// in heap.cpp if SIZE_CLASSES, ALIGNMENT, or SIZE_CLASS_BASE changes.


#ifdef CRYSTAL_HOARD
// NB: This table must match the same table in heap.cpp

#ifdef WIN32
static size_t _superblockSize[hoardHeap::SUPERBLOCK_CLASSES] = { 65536UL };
#else
static size_t _superblockSize[hoardHeap::SUPERBLOCK_CLASSES] = { 8192UL, 65536UL, 262144UL };
#endif

#endif

int main (int, char **)
{
  cout << "size_t hoardHeap::_sizeTable[hoardHeap::SIZE_CLASSES] = {";

  const unsigned long maxUL = (unsigned long) -1;
  int j = 0;
  float sz = 0.0;
  while (j < hoardHeap::SIZE_CLASSES) {
    // Initialize the size class lookup table.
    float newSize = hoardHeap::align (ceil(pow(SIZE_CLASS_BASE, j)));
    if (sz != newSize) {
      sz = newSize;
      if (sz > (float) maxUL) {
	cout << maxUL << "UL";
      } else {
	cout << (unsigned long) sz << "UL";
      }
      if (j < hoardHeap::SIZE_CLASSES - 1) {
	cout << ", ";
      }
    }
    j++;
  }

  cout << "}; " << endl;


  cout << "size_t hoardHeap::_threshold[hoardHeap::SIZE_CLASSES] = {";

  j = 0;
  sz = 0.0;
  while (j < hoardHeap::SIZE_CLASSES) {
    // Initialize the size class lookup table.
    float newSize = hoardHeap::align (ceil(pow(SIZE_CLASS_BASE, j)));
    if (sz != newSize) {
      sz = newSize;

#ifndef CRYSTAL_HOARD
      if (sz > (float) maxUL) {
	cout << hoardHeap::MAX_EMPTY_SUPERBLOCKS * hoardHeap::SUPERBLOCK_SIZE / maxUL << "UL";
      } else {
	cout << hoardHeap::MAX_EMPTY_SUPERBLOCKS * MAX (1, hoardHeap::SUPERBLOCK_SIZE / (unsigned long) sz) << "UL";
      }
#else
      // Crystal Hoard can have different superblock size classes.  Calculate the superblock size.
      if ( sz > (float) maxUL)
      {
	cout << hoardHeap::MAX_EMPTY_SUPERBLOCKS * _superblockSize[hoardHeap::SUPERBLOCK_CLASSES - 1] / maxUL << "UL";
      }
      else
      {
        int nb = 1;
        int sbClass = 0;
        do
        {
          nb = MAX(1, ((_superblockSize[sbClass] - sizeof(superblock)) / (unsigned long)sz));
        }
        while ( (nb == 1) && (++sbClass < hoardHeap::SUPERBLOCK_CLASSES) );

        cout << hoardHeap::MAX_EMPTY_SUPERBLOCKS * MAX (1, _superblockSize[sbClass] / (unsigned long) sz) << "UL";
      }
#endif

      if (j < hoardHeap::SIZE_CLASSES - 1) {
	cout << ", ";
      }
    }
    j++;
  }

  cout << "}; " << endl;

}
