///-*-C++-*-//////////////////////////////////////////////////////////////////
//
// Hoard: A Fast, Scalable, and Memory-Efficient Allocator
//        for Shared-Memory Multiprocessors
// Contact author: Emery Berger, http://www.cs.utexas.edu/users/emery
//
// Copyright (c) 1998-2000, The University of Texas at Austin.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as
// published by the Free Software Foundation, http://www.fsf.org.
//
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
//
// Note: This file was modified by Crystal Decisions in June 2002.
//
//////////////////////////////////////////////////////////////////////////////


#ifndef _WRAPPER_H_
#define _WRAPPER_H_

#include "arch-specific.h"
#include "config.h"
#include "processheap.h"

class wrapper {
public:
  wrapper (void) {
    hoardLockInit(_lock);
  }

  // Return the process heap.  We can't just have a static
  // processHeap, because on some systems this causes problems (e.g.,
  // its destructor is registered by atexit(), which in turn calls
  // malloc()...)  Instantiating the processHeap inside of a buffer of
  // characters avoids this problem, since the destructor won't be
  // added to atexit() at init time.
  processHeap * TheAllocator (void) {
    static int initialized = 0;
    if (!initialized) {
      hoardLock (_lock);
      if (!initialized) {
        buf = (char *) hoardSbrk(sizeof(processHeap));
        TheRealAllocator = new (buf) processHeap;
        initialized = 1;
      }
      hoardUnlock (_lock);
    }
    return TheRealAllocator;
  }

#if !defined(CRYSTAL_HOARD)
  // This destructor causes some problems if the Hoard is LD_PRELOAD'd into sh on Solaris 7.
  // Since it does nothing useful, get rid of it.
  ~wrapper (void) {
    TheRealAllocator->stats();
  }
#endif

private:
  static char * buf;
  static processHeap * TheRealAllocator;
  static hoardLockType _lock;
};


#endif // _WRAPPER_H_

